package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 车辆预定占用
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
@Table(name = "vehicle_record_employ")
public class VehicleRecordEmploy implements Serializable {
	private static final long serialVersionUID = 1L;
	

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Long id;


	@Column(name = "company_id")
	@ApiModelProperty(value = "经营公司id")
	private Integer companyId;



	@Column(name = "vehicle_id")
	@ApiModelProperty(value = "预定id")
	private String vehicleId;


	@Column(name = "book_record_id")
	@ApiModelProperty(value = "店铺id")
	private Long bookRecordId;



	@Column(name = "start_time")
	@ApiModelProperty(value = "开始时间")
	private Long startTime;



	@Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
	private Long endTime;


	@Column(name = "status")
	@ApiModelProperty(value = "状态：1-启用；2-禁用")
	private Integer status;

	

    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;


    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;


	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
	private Integer isDel;
	

}
