package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 平台车辆扩展信息关联表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
@Table(name = "vehicle_extension")
public class VehicleExtension implements Serializable {
	private static final long serialVersionUID = 1L;
	

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	

    @Column(name = "vehicle_id")
	@ApiModelProperty(value = "车辆id")
    private String vehicleId;


	@Column(name = "parent_cata_id")
	@ApiModelProperty(value = "父级扩展id")
	private Integer parentCataId;
	

    @Column(name = "cata_id")
	@ApiModelProperty(value = "扩展id")
    private Integer cataId;
	
	    //删除状态 0：有效 1：删除
    @Column(name = "is_del")
	@ApiModelProperty(value = "删除状态 0：有效 1：删除")
    private Integer isDel;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	

}
