package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * @author hezhen
 * @email 939961241@qq.com
 * @date 2017-08-15 08:03:41
 */
@Data
@Table(name = "sys_log")
public class SysLog implements Serializable {
    private static final long serialVersionUID = 1L;


    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键")
    private Long id;

    @Column(name = "vehicle_id")
    @ApiModelProperty("商品id")
    private String vehicleId;



    @Column(name = "comapny_id")
    @ApiModelProperty("公司id")
    private Integer comapnyId;



    @Column(name = "type")
    @ApiModelProperty("操作类型：1-商家；2-运营平台；3-特惠")
    private Integer type;



    @Column(name = "operate_type")
    @ApiModelProperty("操作类型：1-上架；2-下架")
    private Integer operateType;


    @Column(name = "operation")
    @ApiModelProperty("描述")
    private String operation;



    @Column(name = "time")
    @ApiModelProperty("操作时间")
    private Long time;



    @Column(name = "method")
    @ApiModelProperty("方法")
    private String method;



    @Column(name = "params")
    @ApiModelProperty("参数")
    private String params;




    @Column(name = "ip")
    @ApiModelProperty("Ip")
    private String ip;


    @Column(name = "crt_user")
    @ApiModelProperty("用户id")
    private String crtUser;


    @Column(name = "crt_time")
    @ApiModelProperty("创建时间")
    private Long crtTime;


}
