package com.xxfc.platform.vehicle.constant;

import java.util.HashMap;
import java.util.Map;

public enum RegionType {
    COUNTRY(-1,"国家"),//这一类型不存在db中，只是用于查询所有国家
    REGION(0,"地区"),
    PROVINCE(1,"省/直辖市"),
    CITY(2,"市"),
    PREFECTUR(3,"县"),
    TOWN(4,"镇"),
    ;

    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();
            //Maps.newHashMap();

    static{
        for(RegionType constantType : RegionType.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    RegionType(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
