package com.xxfc.platform.universal.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.admin.entity.AppUserDetail;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;;
import com.xxfc.platform.universal.dto.UploadImgDTO;
import com.xxfc.platform.universal.service.UploadService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;


/**
 * 图片上传
 */
@RestController
@RequestMapping("app/file")
@IgnoreUserToken
@Slf4j
public class AppUploadController {


    @Autowired
    UploadService uploadService;


    private static Integer MAX_DRIVING_LICENSE_SIZE = 10 * 1024 * 1024;//10M


    @RequestMapping(value = "uploadV2", method = RequestMethod.POST)
    public JSONObject uploadV2(@RequestParam("file") MultipartFile file)throws Exception {
        if (file.getSize() > MAX_DRIVING_LICENSE_SIZE) {
            return JsonResultUtil.createFailedResult(2002,"大小超过限制!!!");
        }
        return JsonResultUtil.createSuccessResultWithObj(uploadService.uploadFileV2(file, Long.parseLong(BaseContextHandler.getUserID())));
    }


    @RequestMapping(value = "app/unauth/uploadHead", method = RequestMethod.POST)
    @IgnoreUserToken
    public ObjectRestResponse<String> uploadHead(@RequestBody UploadImgDTO uploadImgDTO)throws Exception {
        return ObjectRestResponse.succ(uploadService.getHeadImg(uploadImgDTO));
    }

}

