package com.xxfc.platform.order.pojo.order;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderActiveDetail;
import com.xxfc.platform.order.entity.OrderItem;
import com.xxfc.platform.order.entity.inter.OrderDetail;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class ActivityOrderBO extends OrderActiveDetail implements OrderDetail {
	private BaseOrder order;
	private AppUserDTO appUserDTO;


	/**
	 * 促成人联系方式
	 */
	@ApiModelProperty(value = "促成人联系方式")
	String facilitatePhone;

	/**
	 * 下单来源，1--app；2--小程序
	 */
	private Integer orderOrigin;

	/**
	 * 优惠券*
	 */
	private List<String> tickerNo;

	/**
	 * 订单子项
	 */
	List<OrderItem> items;

	//商品图片
	private String picture;
	//商品名称
	private String name;
}
