package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.CouponBiz;
import com.xxfc.platform.activity.dto.CouponFindDTO;
import com.xxfc.platform.activity.entity.Coupon;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("coupon")
public class CouponController extends BaseController<CouponBiz, Coupon> {

    @ApiOperation("获取所用优惠卷")
    @GetMapping("/coupons")
    public Map<String, Coupon> coupons() {
        return baseBiz.getCoupons();
    }

    @ApiOperation("获取所用优惠卷")
    @GetMapping("/couponsBycouponIds")
    public List<Coupon> couponsBycouponIds(@RequestParam(value = "tickerNoList") List<String> tickerNoList) {
        return baseBiz.couponsByTickerNoList(tickerNoList);
    }


    @ApiOperation("领劵中心")
    @RequestMapping(value = "app/unauth/ledList", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse ledList(CouponFindDTO couponFindDTO){
        String userIdStr=getCurrentUserId();
        Long userId=0L;
        if (StringUtils.isNotBlank(userIdStr)){
            userId=Long.parseLong(userIdStr);
        }
        couponFindDTO.setUserId(userId);
        couponFindDTO.setStatus(1);
        couponFindDTO.setIsLed(1);
        return ObjectRestResponse.succ(baseBiz.selectList(couponFindDTO));
    }

}