package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.biz.DailyMembersOrderStatisticsBiz;
import com.xxfc.platform.order.biz.DailyTravelOrderStatisticsBiz;
import com.xxfc.platform.order.biz.DailyVehicleOrderStatisticsBiz;
import com.xxfc.platform.order.biz.OrderStatisticsBiz;
import com.xxfc.platform.order.entity.OrderStatistics;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("orderStatistics")
@Api(description = "每月总的订单统计")
public class OrderStatisticsController extends BaseController<OrderStatisticsBiz, OrderStatistics> {
    @Autowired
    private UserFeign userFeign;

    @Autowired
    private UserAuthConfig userAuthConfig;
    /**
     * 租车订单
     */
    private final Integer TYPE_VEHICLE = 1;

    /**
     * 旅游订单 
     */
    private final Integer TYPE_TOUR = 2;

    /**
     * 购买会员订单
     */
    private final Integer TYPE_MEMBER = 3;

    /**
     * 月总数据
     */
    private final Integer TYPE_TOTAL = 4;

    /**
     * 数据权限
     */
    private final  Integer DATA_AUTHORITY=1;

    @Autowired
    private DailyVehicleOrderStatisticsBiz vehicleBiz;


    @Autowired
    private DailyTravelOrderStatisticsBiz TravelBiz;

    @Autowired
    private DailyMembersOrderStatisticsBiz membersBiz;

    @ApiOperation("获取订单统计数据")
    @GetMapping("/findAll/{type}")
    public ObjectRestResponse findAll(@PathVariable Integer type) {


        try {
            ObjectRestResponse<UserDTO> userDTOObjectRestResponse
                    = userFeign.userinfoByToken(userAuthConfig.getToken(getRequest()));

            if (userDTOObjectRestResponse == null || userDTOObjectRestResponse.getData() == null) {
                throw new BaseException("请登录!");
            }
            UserDTO user = userDTOObjectRestResponse.getData();

            Integer companyId = user.getCompanyId();
            if (DATA_AUTHORITY.equals(user.getDataAll())){
                companyId=null;
            }

            if (TYPE_VEHICLE.equals(type)) {
                OrderStatistics vehicle = vehicleBiz.findAll(companyId);
                return ObjectRestResponse.succ(vehicle);
            }
            if (TYPE_TOUR.equals(type)) {
                OrderStatistics tour = TravelBiz.findAll(companyId);
                return ObjectRestResponse.succ(tour);
            }
            if (TYPE_MEMBER.equals(type)) {
                OrderStatistics member = membersBiz.findAll(companyId);
                return ObjectRestResponse.succ(member);
            }

            if (TYPE_TOTAL.equals(type)) {
                return ObjectRestResponse.succ(baseBiz.getTotalOrder(companyId));
            }

            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "参数错误!");
        } catch (Exception e) {
            e.printStackTrace();
            return ObjectRestResponse.createDefaultFail();
        }

    }
}
