package com.xxfc.platform.order.pojo.account;

import lombok.Data;
import org.assertj.core.util.Lists;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderAccountDetail {
    /**
     * 实际返回订单款
     */
    BigDecimal orderAmount;
    /**
     * 实际返回押金款
     */
    BigDecimal depositAmount;
    /**
     * 原来要返回的订单款
     */
    BigDecimal originOrderAmount;
    /**
     * 原来要返回的押金款
     */
    BigDecimal originDepositAmount;

    /**
     * 扣款列表
     */
    List<OrderAccountDeduction> deductions = Lists.newArrayList();
}
