package com.xxfc.platform.order.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description 订单概况
 * @data 2019/12/24 16:33
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "order_profile_display")
public class OrderProfileDisplay {
    @Id
    @GeneratedValue(generator = "JDBC")
    private Integer id;

    /**
     * 订单日期
     */
    @Column(name = "order_date")
    private Date orderDate;
    /**
     * 订单金额
     */
    @Column(name = "order_amount")
    private BigDecimal orderAmount;
//    /**
//     * 订单量
//     */
//    @Column(name = "order_num")
//    private Integer orderNum;
//    /**
//     * 支付方式 1:微信 2:支付宝
//     */
//    @Column(name = "pay_way")
//    private Integer payWay;
//    /**
//     * 支付终端 1：app 2:小程序 3：公众号 4：ios
//     */
//    @Column(name = "pay_terminal")
//    private Integer payTerminal;
//    /**
//     * 订单类型 1:租车 2：旅游 3：会员
//     */
//    @Column(name = "order_type")
//    private Integer orderType;

}
