package com.github.wxiaoqi.security.admin.rest;


import com.github.wxiaoqi.security.admin.biz.UserCommentBiz;
import com.github.wxiaoqi.security.admin.dto.UserCommentFindDTO;
import com.github.wxiaoqi.security.admin.entity.UserComment;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/comment")
@Api(tags = {"评论"})
public class AppUserCommentController extends BaseController<UserCommentBiz> {







    @GetMapping("app/unauth/selectList")
    @ApiModelProperty("列表")
    @IgnoreUserToken
    public  ObjectRestResponse selectList(UserCommentFindDTO commentFindDTO) {
        return ObjectRestResponse.succ( baseBiz.selectList(commentFindDTO));
    }



    @PostMapping("send")
    @ApiModelProperty("评论")
    public  ObjectRestResponse apply(@RequestBody UserComment userComment) {
        userComment.setUserId(getCurrentUserIdInt());
        Integer isCompany = userComment.getIsCompany() == null ? 0 : userComment.getIsCompany();
        if (isCompany == 1 && (userComment.getCompanyId() == null || userComment.getCompanyId() == 0)){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                userComment.setCompanyId(companyIds.get(0));
            }
        }
        baseBiz.addOrUpd(userComment);
        return ObjectRestResponse.succ();
    }



    @GetMapping("selectListByToUserId")
    @ApiModelProperty("列表")
    public  ObjectRestResponse selectListByToUserId(UserCommentFindDTO commentFindDTO) {
        commentFindDTO.setUserId(getCurrentUserIdInt());
        Integer isGoods = commentFindDTO.getIsGoods() == null ? 0 : commentFindDTO.getIsGoods();
        if (isGoods == 2 && (commentFindDTO.getCompanyId() == null || commentFindDTO.getCompanyId() == 0)){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                commentFindDTO.setCompanyId(companyIds.get(0));
            }
        }
        return ObjectRestResponse.succ( baseBiz.selectListByToUserId(commentFindDTO));
    }



    @PostMapping("del")
    @ApiModelProperty("评论删除")
    public  ObjectRestResponse del(@RequestBody UserComment userComment) {
        userComment.setIsShow(0);
        baseBiz.updateSelectiveById(userComment);
        return ObjectRestResponse.succ(); 
    }


    @GetMapping("selectListByCommentId")
    @ApiModelProperty("列表")
    public  ObjectRestResponse selectListByCommentId(UserCommentFindDTO commentFindDTO) {
        if (commentFindDTO.getCompanyId() == null || commentFindDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                commentFindDTO.setCompanyId(companyIds.get(0));
            }
        }
        commentFindDTO.setIsGoods(2);
        return ObjectRestResponse.succ( baseBiz.selectListV2(commentFindDTO));
    }


    @PostMapping("saveComment")
    @ApiModelProperty("评论")
    public  ObjectRestResponse saveComment(@RequestBody UserComment userComment) {
        userComment.setUserId(getCurrentUserIdInt());
        baseBiz.saveComment(userComment);
        return ObjectRestResponse.succ();
    }

    @GetMapping("app/unauth/selectCommentList")
    @ApiModelProperty("列表")
    @IgnoreUserToken
    public  ObjectRestResponse selectCommentList(UserCommentFindDTO commentFindDTO) {
        return ObjectRestResponse.succ( baseBiz.selectList(commentFindDTO));
    }
}
