package com.xxfc.platform.app.rest;

import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.app.biz.AppVersionBiz;
import com.xxfc.platform.app.entity.AppVersion;
import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.app.vo.appVersionQuery;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Delete;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("version")
@IgnoreClientToken
public class AppVersionController extends BaseController<AppVersionBiz,AppVersion> {
      //最大上传500MB
     private Long MAX_DRIVING_LICENSE_SIZE =1024*1024*500L;
    private int id;

    @ApiModelProperty("app自动更新")
    @RequestMapping(value ="/app/unauth/info",method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse info(
            @RequestParam(value = "type",defaultValue = "0") Integer type,
            @RequestParam(value = "version",defaultValue = "") String version,
            @RequestParam(value = "isH5",defaultValue = "0") Integer isH5
    ){
        ObjectRestResponse restResponse=null;
         if (isH5!=null&&isH5==1){
             restResponse= baseBiz.getVersionH5(type);
         }else {
             restResponse=baseBiz.getVersion(version,type);
         }
        return restResponse;
    }


    @Override
    @ApiOperation("添加")
    @RequestMapping(value = "/background/add",method = RequestMethod.POST)
    public ObjectRestResponse<AppVersion> add(@RequestBody AppVersion appVersion){
        baseBiz.insertAppVersion(appVersion);
        return new ObjectRestResponse<AppVersion>();
    }


    @ApiOperation("查询")
    @RequestMapping(value = "/background/getAppVersion/{id}",method = RequestMethod.GET)
    public ObjectRestResponse<AppVersion> getAppVersion(@PathVariable Integer id){
        return ObjectRestResponse.succ(baseBiz.get(id));
    }

    @ApiOperation("查询所有")
    @RequestMapping(value = "/background/getAppVersions",method = RequestMethod.POST)
    public ObjectRestResponse<PageInfo<AppVersion>> getAppVersions(@RequestBody appVersionQuery query){
        return ObjectRestResponse.succ(baseBiz.getAll(query));
    }

    @Override
    @ApiOperation("修改")
    @RequestMapping(value = "/background/update/{id}",method = RequestMethod.PUT)
    public ObjectRestResponse<AppVersion> update(@RequestBody AppVersion appVersion){
        baseBiz.updateAppVersionById(appVersion);
        return new ObjectRestResponse<AppVersion>();
    }

    @ApiOperation("删除")
    @DeleteMapping(value = "/background/remove/{id}")
    public ObjectRestResponse<AppVersion> remove(@PathVariable Integer id){
        baseBiz.remove(id);
        return new ObjectRestResponse<AppVersion>();
    }



    @PostMapping(value = "/upload/installationPackage")
    @ApiOperation(value = "上传app安装包")
    public RestResponse uploadInstallationPackage(@RequestParam("file") MultipartFile file)
            throws Exception {
        Assert.notNull(file);
        String contentType = file.getContentType();   //文件类型
////        String fileName = file.getOriginalFilename();  //文件名
        if (!contentType.equals("apk") && !contentType.equals("ipa")) {
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        if (file.getSize() > MAX_DRIVING_LICENSE_SIZE) {
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return baseBiz.uploadDrivingLicense(file);
    }




    @IgnoreUserToken
    @GetMapping(value = "/download/installationPackage/{realFileRelPath}") //匹配的是href中的download请求
    @ApiOperation(value = "下载app安装包")
    public ResponseEntity<byte[]> downloadInstallationPackage(@RequestParam("realFileRelPath") String realFileRelPath) throws Exception {
        return baseBiz.downloadInstallationPackage(realFileRelPath);
    }

}