package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.common.msg.ListRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.tour.biz.TourUserBiz;
import com.xxfc.platform.tour.common.TourBaseController;
import com.xxfc.platform.tour.entity.TourUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("tourUser")
public class TourUserController extends TourBaseController<TourUserBiz> {

    @Autowired
    private TourUserBiz userBiz;

    @GetMapping("/app/unauth/getTourUser/{isChild}")
    public ListRestResponse getTourUser(@PathVariable int isChild){
//        AppUserDTO userInfo = getUserInfo();
//        Integer id = userInfo.getId();
        Integer id =14;
       List<TourUser> tourUsers= userBiz.getTourUser(id,isChild);

       return new ListRestResponse().result(tourUsers).count(tourUsers.size());
    }




}