package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.common.msg.ListRestResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.tour.biz.TourBannerBiz;
import com.xxfc.platform.tour.entity.TourBanner;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * banner图
 */
@RestController
@RequestMapping("tourBanner")
public class TourBannerController extends BaseController<TourBannerBiz,TourBanner> {

    @Autowired
    private TourBannerBiz bannerBiz;


    /**
     *查询banner图
     * @return
     */
    @GetMapping("/app/unauth/findBannerlist")
    public ListRestResponse findBannerlist(){

        List<TourBanner> bannerList = bannerBiz.findBannerList();


        return new ListRestResponse().result(bannerList).count(bannerList.size());
    }


    @Override
    @ApiOperation("修改")
    @RequestMapping(value = "/{id}",method = RequestMethod.PUT)
    public ObjectRestResponse<TourBanner> update(@RequestBody TourBanner banner){
        bannerBiz.update(banner);
        return new ObjectRestResponse<TourBanner>();
    }



    @Override
    @ApiOperation("删除")
    @RequestMapping(value = "/{id}",method = RequestMethod.DELETE)
    public ObjectRestResponse<TourBanner> remove(@PathVariable int id){
          bannerBiz.remove(id);
         return new ObjectRestResponse<TourBanner>();
    }






}