package com.xxfc.platform.tour.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.comstnt.RedisKey;
import com.xxfc.platform.tour.entity.TourBanner;
import com.xxfc.platform.tour.mapper.TourTagMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import com.xxfc.platform.tour.entity.TourTag;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.List;
import java.util.Map;

/**
 * 旅游路线标签
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Service
public class TourTagBiz extends BaseBiz<TourTagMapper,TourTag> {

    @Autowired
    private RedisTemplate redisTemplate;




    @Autowired
    private TourTagBiz tagBiz;

    @Cache(key = RedisKey.CONSTANT_CODE_PREFIX_HOTTAG)
    public List<TourTag> getHotTag() {

        TourTag tag = new TourTag();
        tag.setIsDel(0);
        tag.setIsHot(1);
        return mapper.findHotListTag(tag);
    }



    public PageDataVO<TourTag> findAll(Map map) {
        TourTag tag = new TourTag();
        tag.setIsDel(0);
        return PageDataVO.pageInfo((Integer)map.get("page"),(Integer)map.get("limit"),() -> mapper.findAllByIsDel(tag));
    }



    @CacheClear(key = RedisKey.CONSTANT_CODE_PREFIX_HOTTAG)
    public void update(TourTag banner) {
        this.updateSelectiveById(banner);
    }


    @CacheClear(key = RedisKey.CONSTANT_CODE_PREFIX_HOTTAG)
    public void remove(int id) {
        this.deleteById(id);
    }

}