package com.xxfc.platform.tour.biz;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.mapper.TourGoodMapper;
import com.xxfc.platform.tour.mapper.TourGoodSiteMapper;
import com.xxfc.platform.tour.mapper.TourGoodSpePriceMapper;
import com.xxfc.platform.tour.vo.TourDepartTimeVo;
import com.xxfc.platform.tour.vo.TourDepartVo;
import com.xxfc.platform.tour.vo.TourGoodDetailVo;
import com.xxfc.platform.tour.vo.TourMemberVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xxfc.platform.tour.entity.TourGoodSpePrice;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

/**
 * 旅游商品规格价格表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Service
@Slf4j
public class TourGoodDetailBiz extends BaseBiz<TourGoodMapper, TourGood> {


    @Autowired
    TourGoodSpePriceMapper priceMapper;
    @Autowired
    TourGoodSiteMapper siteMapper;

    //获取商品详情
    public ObjectRestResponse<TourGoodDetailVo> getGoodDetaileById(Integer id){
            if(id==null||id==0){
                return   ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "参数为空");
            }
        try {
            TourGood TourGood = mapper.getOne(id);
            if (TourGood != null) {
                TourGoodDetailVo detailVo = new TourGoodDetailVo();
                BeanUtils.copyProperties(detailVo, TourGood);
                BigDecimal price=detailVo.getPrice();
                if(price!=null&&detailVo.getIsMember()>0){
                    List<TourMemberVo> memberList=new ArrayList<>();
                    for(int i=1;i<4;i++){
                        TourMemberVo memberVo=new TourMemberVo();
                        memberVo.setLevel(i);
                        memberVo.setName(getName(i));
                        BigDecimal member_price=price.multiply(new BigDecimal("0.88")).setScale(2, RoundingMode.HALF_UP);  ;
                        memberVo.setPrice(member_price);
                        memberList.add(memberVo);
                    }
                    detailVo.setMemberVo(memberList);
                }
                //获取出行时间

                List<TourDepartTimeVo> timelist=priceMapper.getAllByGoodId(id);
                detailVo.setTourDepartTimeVo(timelist);
                //获取出发地点
                List<TourDepartVo> departList=siteMapper.getlistByGoodId(id);
                detailVo.setTourDepartVo(departList);
                return   ObjectRestResponse.succ(detailVo);
            }
            return   ObjectRestResponse.createDefaultFail();
        }catch (Exception e) {
            e.printStackTrace();
            log.error("---商品详情---id====="+id+"----异常---msg==="+ e.getMessage());
            return   ObjectRestResponse.createFailedResult(ResultCode.EXCEPTION_CODE, "出现异常");
        }
    }

    public String  getName(Integer type){
        String name="";
        switch (type){
            case 1:
                name="普通会员";
                break;
            case 2:
                name="黄金会员";
                break;
            case 3:
                name="钻石会员";
                break;


        }
         return  name;
    }



}