package com.xxfc.platform.tour.biz;

import com.github.pagehelper.PageHelper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.mapper.TourGoodMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 旅游商品表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Service
@Slf4j
public class TourGoodBiz extends BaseBiz<TourGoodMapper, TourGood> {

    @Autowired
    private TourGoodMapper tourGoodMapper;

    /**
     * 查询旅游路线列表
     * @param page
     * @param limit
     * @param query
     * @param latitude
     * @param longitude
     * @param tagId
     * @param distance
     * @return
     */
    public PageDataVO<TourGood> getGoodList(int page, int limit , String query , Double latitude, Double longitude, Integer tagId, Double distance){
        Map<String, Object> params = initParam(page, limit, query, latitude, longitude, tagId, distance);
        return  PageDataVO.pageInfo(page, limit, () -> mapper.getGoodList(params));
    }

    private Map<String, Object> initParam(int page, int limit, String query, Double latitude, Double longitude, Integer tagId, Double distance) {
        Map<String,Object> params = new HashMap<String,Object>();
        params.put("query",query);
        params.put("latitude",latitude);
        params.put("longitude",longitude);
        params.put("tagId",tagId);
        params.put("distance",distance);
        return params;
    }
}