package com.xxfc.platform.tour.feign;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.tour.dto.TourSpePriceDTO;
import com.xxfc.platform.tour.vo.TourSpePriceVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-tour")
public interface TourFeign {

    /**
     * 计算价格
     * @param spePriceDto
     * @return
     */
    @RequestMapping(value = "/spe/user/prices", method = RequestMethod.POST)
    public ObjectRestResponse<TourSpePriceVo> refund(@RequestBody TourSpePriceDTO spePriceDto);

    @RequestMapping(value = "/spe/stock", method = RequestMethod.GET)
    public ObjectRestResponse<TourSpePriceVo> stock(Integer speId,Integer number);

}
