package com.xxfc.platform.tour.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 路线站点表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
@Table(name = "tour_good_site")
public class TourGoodSite implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    //路线id
    @Column(name = "good_id")
	@ApiModelProperty(value = "路线id")
    private Integer goodId;
	
	    //站点名称
    @Column(name = "name")
	@ApiModelProperty(value = "站点名称")
    private String name;
	
	    //站点地址
    @Column(name = "address")
	@ApiModelProperty(value = "站点地址")
    private String address;

    //分公司id
	@Column(name = "company_id")
	@ApiModelProperty(value = "分公司id")
	private String companyId;


	//出发时间
    @Column(name = "depart_time")
	@ApiModelProperty(value = "出发时间")
    private Long departTime;
	
	    //站点经度
    @Column(name = "longitude")
	@ApiModelProperty(value = "站点经度")
    private Double longitude;
	
	    //站点纬度
    @Column(name = "latitude")
	@ApiModelProperty(value = "站点纬度")
    private Double latitude;
	
	    //类型：0起点，1-途径点；2-终点
    @Column(name = "type")
	@ApiModelProperty(value = "类型：0起点，1-途径点；2-终点")
    private Integer type;
	
	    //排序
    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	    //状态 0正常 1关闭
    @Column(name = "status")
	@ApiModelProperty(value = "状态 0正常 1关闭")
    private Integer status;
	
	    //创建时间
    @Column(name = "ctr_time")
	@ApiModelProperty(value = "创建时间")
    private Long ctrTime;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    //站点介绍
    @Column(name = "intro")
	@ApiModelProperty(value = "站点介绍")
    private String intro;
	
	    //是否删除；0-正常；1-删除
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isDel;
	

}
