package com.xxfc.platform.order.biz;

import cn.hutool.core.lang.Dict;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.entity.OrderTemplate;
import com.xxfc.platform.order.mapper.OrderTemplateMapper;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 费用明细
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-04 22:14:33
 */
@Service
public class OrderTemplateBiz extends BaseBiz<OrderTemplateMapper,OrderTemplate> {

    public String result (OrderTemplate orderTemplate, Dict dict) {
//        TemplateEngine engine = TemplateUtil.createEngine(new TemplateConfig());
//        OrderCostDetail orderCostDetail = orderCostDetailBiz.selectById(OrderCostEnum.RentVehicle.getCode());
//        Template template = engine.getTemplate(orderCostDetail.getTemplate());
//        String result = template.render(Dict.parse(pojo));
//        pojo.setCostDetail(result);
        List<OrderTemplate> all = this.selectListAll();
        Map<String, Object> allCodeMap = all.parallelStream().collect(Collectors.toMap(item -> "tem_"+ item.getCode(), OrderTemplate::getTemplate));
        List<String> codes = all.parallelStream().map(OrderTemplate::getCode).collect(Collectors.toList());

        String result = "";
        TemplateEngine engine = TemplateUtil.createEngine();
        //匹配模板 ParamKey() 判断是否存在别的模板
        List<String> list = Arrays.asList(orderTemplate.getParamKey().split(",")).parallelStream().filter(item -> codes.contains(item)).collect(Collectors.toList());
        if(list.size() > 0) {
            allCodeMap.remove("tem_0101");
            Template template = engine.getTemplate(orderTemplate.getTemplate());
            result = template.render(new Dict(allCodeMap));
        }

        //匹配参数 填充参数
        return result;
    }

//    public Map<String, OrderTemplate> allCodeMap() {
//       return this.selectListAll().parallelStream().collect(Collectors.toMap(OrderTemplate::getCode, template -> template));
//    }
}