package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-24 21:56:10
 */
@Table(name = "base_order")
@Data
public class BaseOrder implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    //订单号
    @Column(name = "no")
	@ApiModelProperty(value = "订单号")
    private String no;
	
	    //订单类型
    @Column(name = "type")
	@ApiModelProperty(value = "订单类型")
    private Integer type;
	
	    //订单详情id
    @Column(name = "detail_id")
	@ApiModelProperty(value = "订单详情id")
    private Integer detailId;
	
	    //订单状态
    @Column(name = "status")
	@ApiModelProperty(value = "订单状态")
    private Integer status;
	
	    //商品价格
    @Column(name = "goods_amount")
	@ApiModelProperty(value = "商品价格")
    private BigDecimal goodsAmount;
	
	    //实际价格
    @Column(name = "order_amount")
	@ApiModelProperty(value = "订单价格")
    private BigDecimal orderAmount;

	//实际价格
	@Column(name = "real_amount")
	@ApiModelProperty(value = "实际价格")
	private BigDecimal realAmount;
	
	    //详情json信息
    @Column(name = "detail_json")
	@ApiModelProperty(value = "详情json信息")
    private String detailJson;
	
	    //第三方类型（支付渠道）
    @Column(name = "third_type")
	@ApiModelProperty(value = "第三方类型（支付渠道）")
    private Integer thirdType;
	
	    //流水号
    @Column(name = "out_trade_no")
	@ApiModelProperty(value = "流水号")
    private String outTradeNo;

		/**
		 * 用户id
		 */
	@Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
	private Integer userId;

	/**
	 * 订单图片
	 */
	@Column(name = "picture")
	@ApiModelProperty(value = "订单图片")
	private String picture;

	/**
	 * 订单图片
	 */
	@Column(name = "name")
	@ApiModelProperty(value = "名称")
	private String name;

	/**
	 * 取消原因
	 */
	@Column(name = "cancel_reason")
	@ApiModelProperty(value = "取消原因")
	private String cancelReason;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    //创建者id
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建者id")
    private String crtUser;
	
	    //创建者名称
    @Column(name = "crt_name")
	@ApiModelProperty(value = "创建者名称")
    private String crtName;
	
	    //创建者ip
    @Column(name = "crt_host")
	@ApiModelProperty(value = "创建者ip")
    private String crtHost;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Date updTime;
	
	    //更新者id
    @Column(name = "upd_user")
	@ApiModelProperty(value = "更新者id")
    private String updUser;
	
	    //更新者名称
    @Column(name = "upd_name")
	@ApiModelProperty(value = "更新者名称")
    private String updName;
	
	    //更新者ip
    @Column(name = "upd_host")
	@ApiModelProperty(value = "更新者ip")
    private String updHost;
}
