package com.github.wxiaoqi.security.common.msg;

import com.github.wxiaoqi.security.common.constant.RestCode;
import com.github.wxiaoqi.security.common.util.SystemProperty;
import com.github.wxiaoqi.security.common.util.process.ResultCode;

/**
 * Created by Ace on 2017/6/11.
 */
public class ObjectRestResponse<T> extends BaseResponse {

    T data;
    boolean rel;
    private static final Integer WEB_CALL_RESULT_SUCCESS = ResultCode.SUCCESS_CODE;
    private static final Integer WEB_CALL_RESULT_FAILED = ResultCode.FAILED_CODE;
    private static final String RESULT_SUCCESS_MSG = "操作成功";
    private static final String RESULT_FAIL_MSG = "操作失败";

    public boolean isRel() {
        return rel;
    }

    public void setRel(boolean rel) {
        this.rel = rel;
    }


    public ObjectRestResponse rel(boolean rel) {
        this.setRel(rel);
        return this;
    }

    public ObjectRestResponse data(T data) {
        this.setData(data);
        return this;
    }

    public ObjectRestResponse status(Integer status) {
        this.setStatus(status);
        return this;
    }

    public ObjectRestResponse msg(String msg) {
        this.setMessage(msg);
        return this;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static ObjectRestResponse succ() {
        return ObjectRestResponse.succ(null);
    }

    public static <T> ObjectRestResponse succ(T data) {
        return new ObjectRestResponse().status(RestCode.SUCCESS.getStatus()).msg(RestCode.SUCCESS.getMsg()).data(data).rel(true);
    }

    /**
     * 创建一个异常的调用结果，根据code获取对应的提示
     * @param code
     * @return
     */
    public static ObjectRestResponse createFailedResultMsg(Integer code) {
        return new ObjectRestResponse().status(code).msg(SystemProperty.getResultConfig(code + "")).rel(false);
    }

    /**
     * 创建一个异常的调用结果
     * @param message
     * @return
     */
    public static ObjectRestResponse createFailedResult(Integer code, String message) {
        return  new ObjectRestResponse().status(code).msg(message).rel(false);
    }

    /**
     * 操作失败
     * @return
     */
    public static ObjectRestResponse createDefaultFail() {
        return  new ObjectRestResponse().status(WEB_CALL_RESULT_FAILED).msg(RESULT_FAIL_MSG).rel(false);
}
}
