package com.xxfc.platform.vehicle.rest;

import com.xxfc.platform.vehicle.biz.VehicleUpkeepService;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.VehicleUpkeepItem;
import com.xxfc.platform.vehicle.pojo.VehicleUpkeepLogItemVo;
import com.xxfc.platform.vehicle.pojo.VehicleUpkeepLogVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.InvocationTargetException;

@RestController
@RequestMapping("upkeep")
public class VehicleUpkeepController {


    @Autowired
    private VehicleUpkeepService vehicleUpkeepService;

    /**
     * 查询所有保养项目
     * @return
     */
    @GetMapping("item/all")
    public RestResponse allItem() {
        return RestResponse.suc(vehicleUpkeepService.getAllItem());
    }

    /**
     * 分页查询所用保养项目
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("item/page")
    public RestResponse pageItem(Integer page, Integer limit) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(vehicleUpkeepService.pageItem(page, limit));
    }

    /**
     * 添加保养项目
     * @param name
     * @return
     */
    @PostMapping("item")
    public RestResponse addItem(String name) {
        if (name == null || name.trim().equals("")) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleUpkeepService.addItem(name);
        return RestResponse.suc();
    }

    /**
     * 修改项目
     * @param item
     * @return
     */
    @PutMapping("item")
    public RestResponse editItem(VehicleUpkeepItem item) {
        if (item == null || item.getId() == null || item.getName() == null || item.getName().trim().equals("")) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleUpkeepService.updateItem(item);
        return RestResponse.suc();
    }

    /**
     * 删除保养项目
     * @param id
     * @return
     */
    @DeleteMapping("item/{id}")
    public RestResponse delItem(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleUpkeepService.deleteItem(id);
        return RestResponse.suc();
    }

    /**
     * 分页查询保养记录
     * @param numberPlate
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("log/page")
    public RestResponse pageLog(String numberPlate, Integer page, Integer limit) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(vehicleUpkeepService.pageLog(numberPlate, page, limit));
    }

    /**
     * 根据id查询一条保养记录(包含车牌、分公司名和保养项目)
     * @param id
     * @return
     */
    @GetMapping("log/{id}")
    public RestResponse getLog(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(vehicleUpkeepService.getLogVoById(id));
    }

    /**
     * 根据id删除一条保养记录
     * @param id
     * @return
     */
    @DeleteMapping("log/{id}")
    public RestResponse delLog(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleUpkeepService.deleteLog(id);
        return RestResponse.suc();
    }

    /**
     * 添加一条保养记录
     * @param vulvo
     * @return
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    @PostMapping("log/addLog")
    public RestResponse addLog(VehicleUpkeepLogVo vulvo) throws InvocationTargetException, IllegalAccessException {

        if (vulvo==null) {

            return  RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleUpkeepService.addLog(vulvo);
        return RestResponse.suc();
    }

}
