package com.xxfc.platform.vehicle.pojo;

import lombok.Data;

import javax.persistence.Column;
import java.util.Date;

@Data
public class VehicleBookRecordAndTbNameVo {

    /**
     * 表格名称
     */
    private String tbName;
    /**
     * 主键
     */
    private Long id;

    /**
     * 车辆id
     */
    private String vehicle;

    /**
     * 申请状态：1-申请中 2-已通过 3-已归还 4-拒绝 5-逾期归还
     */
    private Integer status;

    /**
     * 预定类型，1-用户租赁、2-分公司使用、3-维修
     */
    private Integer bookType;

    /**
     * 预定用户id
     */
    private Integer bookUser;

    /**
     * 预定用户姓名
     */
    private String bookUserName;

    /**
     * 联系信息，比如电话、联系人姓名等(json)
     */
    @Column(name = "contact_info")
    private String contactInfo;

    /**
     * 申请开始日期
     */
    private Date bookStartDate;

    /**
     * 提车地点(经纬度)
     */
    private String liftLocation;

    /**
     * 提车地址
     */
    private String liftAddr;

    private String remark;

    /**
     * 目的地
     */
    private String destination;

    /**
     * 申请审核人，-1代表系统
     */
    private Integer reviewerApply;

    /**
     * 申请审核人姓名
     */
    private String reviewerNameApply;

    /**
     * 归还审核人，-1代表系统
     */
    private Integer reviewerReturn;

    /**
     * 归还审核人姓名
     */
    private String reviewerNameReturn;


    /**
     * 取消人，-1代表系统
     */
    private Integer reviewerCancel;

    /**
     * 取消人姓名
     */
    private String reviewerNameCancel;

    /**
     * 提车审核人，-1代表系统
     */
    private Integer reviewerLift;

    /**
     * 提车审核人姓名
     */
    private String reviewerNameLift;

    /**
     * 申请结束日期
     */
    @Column(name = "book_end_date")
    private Date bookEndDate;

    /**
     * 实际开始日期
     */
    private Date actualStartDate;

    /**
     * 实际结束日期
     */
    private Date actualEndDate;

    /**
     * 提车公司
     */
    private Integer liftCompany;

    /**
     * 提车备注
     */
    private String liftRemark;


    /**
     * 还车公司
     */
    private Integer retCompany;

    /**
     * 还车备注
     */
    private String retRemark;

    /**
     * 提车阶段里程数
     */
    private Integer mileageLift;

    /**
     * 还车阶段里程数
     */
    private Integer mileageRet;

    /**
     * 是否违章
     */
    private Integer haveViolation;


}