package com.xxfc.platform.tour.mapper;


import  com.xxfc.platform.tour.entity.TourGoodVerification;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.tour.vo.TourGoodOrderVo;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

/**
 * 旅游线路核销明细
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-14 09:36:50
 */
public interface TourGoodVerificationMapper extends Mapper<TourGoodVerification> {

    //删除线路核销
    public int  delVerification(@Param("goodId")Integer goodId, @Param("list") List<Integer> ids);


    /**
     * 保存线路核销
     * @param tourGoodVerification
     * @return
     */
    @Insert("insert into tour_good_verification(`spe_id`,`site_id`,`good_id`)values(#{speId} ,#{siteId} ,#{goodId}) where `spe_id`<>#{speId} and `site_id`<>#{siteId} and `good_id`<>#{goodId}")
    int insertTourGoodVerification(TourGoodVerification tourGoodVerification);

    /**
     * 更新总人数 或 上车人数
     * @param properties
     * @return
     */
    @Update("update tour_good_verification set ${properties}=${properties}+1 where `id`=#{verficationId}")
    int updateTourGoodPerNumbs(@Param("verficationId") Integer verficationId,@Param("properties") String properties);

    /**
     * 更新出发状态
     * @param status
     * @param verficationId
     * @return
     */
    @Update("update tour_good_verification set `status`=#{status} where where `id`=#{verficationId}")
    int updateStatusByGoodIdAndSpeIdAndSiteId(@Param("verficationId") Integer verficationId,@Param("status") Integer status);

    /**
     * 查询核销订单
     * @param tourGoodOrderFindVo
     * @return
     */
    List<TourGoodOrderVo> findVerificationAll(TourGoodOrderFindVo tourGoodOrderFindVo );
}
