package com.xxfc.platform.im.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 评论表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-24 19:14:43
 */
@Data
@Table(name = "im_comment")
public class ImComment implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Long id;
	
	    /**
     *  问题Id
     */
    @Column(name = "question_id")
	@ApiModelProperty(value = "问题Id")
    private Long questionId;
	
	    /**
     *  评论类容
     */
    @Column(name = "content")
	@ApiModelProperty(value = "评论类容")
    private String content;
	
	    /**
     *  
     */
    @Column(name = "time")
	@ApiModelProperty(value = "")
    private Long time;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Long userId;
	
	    /**
     *  是否显示
     */
    @Column(name = "visible")
	@ApiModelProperty(value = "是否显示")
    private String visible;
	
	    /**
     *  是否只有自己可见(评论审核时仅自己可见)
     */
    @Column(name = "visible_own")
	@ApiModelProperty(value = "是否只有自己可见(评论审核时仅自己可见)")
    private String visibleOwn;
	
	    /**
     *  状态
     */
    @Column(name = "state")
	@ApiModelProperty(value = "状态")
    private String state;

	/**
	 *  是否删除0-正常，1-删除
	 */
	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除")
	private String isDel;

}
