package com.github.wxiaoqi.security.admin.biz;


import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.dto.AppUserCollectDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserCollect;
import com.github.wxiaoqi.security.admin.mapper.AppUserCollectMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 16:23
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class AppUserCollectBiz extends BaseBiz<AppUserCollectMapper, AppUserCollect> {


    //新增收藏
    public ObjectRestResponse addUserCollect(AppUserCollectDTO collectDTO)throws  Exception{
        Integer typeId=collectDTO.getTypeId();
        Integer type=collectDTO.getType();
          if(collectDTO==null||typeId==null||type==null){
              return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "参数为空");
          }
        Example example = new Example(AppUserCollect.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId",collectDTO.getUserId()).andEqualTo("typeId",typeId)
                .andEqualTo("type",type).andEqualTo("isDel",0);
        int count=selectCountByExample(example);
        if (count>0){
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "已收藏!");
        }
          AppUserCollect collect=new AppUserCollect();
          BeanUtils.copyProperties(collect,collectDTO);
          insertSelective(collect);
         return  ObjectRestResponse.succ();
    }

    //更新收藏
    public ObjectRestResponse upUserCollect(AppUserCollectDTO collectDTO)throws  Exception{
        if(collectDTO==null){
            return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        AppUserCollect collect=new AppUserCollect();
        BeanUtils.copyProperties(collect,collectDTO);
        updateSelectiveById(collect);
        return  ObjectRestResponse.succ();
    }
    //查看是否收藏
    public ObjectRestResponse checkUserCollect(Integer id,Integer userId,Integer type){
        Example example = new Example(AppUserCollect.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId",userId).andEqualTo("typeId",id).
                andEqualTo("type",type).andEqualTo("isDel",0).andEqualTo("status",0);
       int count=0;
       Integer collect_id=0;
       List<AppUserCollect> list=selectByExample(example);
       if(list.size()>0){
           count=1;
           collect_id= list.get(0).getId();
       }
        JSONObject obj=new JSONObject();
        obj.put("status",count);
        obj.put("id",collect_id);
        return  ObjectRestResponse.succ(obj);
    }
    //我的收藏
    public ObjectRestResponse getCollectList(Integer userId,int page,int limit){
        Example example = new Example(AppUserCollect.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId",userId).andEqualTo("isDel",0).andEqualTo("status",0);
        example.setOrderByClause("`id` desc");
        List<AppUserCollect> list=selectByExample(example);
        PageHelper.startPage(page,limit);
        PageInfo<AppUserCollect> pageInfo = new PageInfo<>(mapper.selectByExample(example));
        return  ObjectRestResponse.succ(PageDataVO.pageInfo(pageInfo));
    }















}
