package com.xxfc.platform.vehicle.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 预定车辆用途
 */
public enum BookType {
    EMPLOYEE_APPLY(1,"还车"),
    USER_RENT(2,"租车"),
    REPAIRING(3,"维修"),
    SHOW(4,"展览"),
    TOUR(5,"旅游"),
    MAINTAIN(6,"保养"),
    BOOKING(7,"预约中"),
    DISABLE(8,"禁用")
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();
            //Maps.newHashMap();

    static{
        for(BookType constantType : BookType.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    BookType(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
