package com.xxfc.platform.order.biz;

import cn.hutool.json.JSONUtil;
import com.xxfc.platform.order.contant.enumerate.*;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.entity.OrderVehicleCrosstown;
import com.xxfc.platform.order.pojo.DedDetailDTO;
import com.xxfc.platform.order.pojo.mq.OrderMQDTO;
import com.xxfc.platform.universal.constant.DictionaryKey;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.ThirdFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xxfc.platform.order.entity.OrderRefund;
import com.xxfc.platform.order.mapper.OrderRefundMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import static com.xxfc.platform.universal.constant.DictionaryKey.APP_ORDER;

/**
 * 订单退款记录表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-18 11:08:09
 */
@Service
public class OrderRefundBiz extends BaseBiz<OrderRefundMapper,OrderRefund> {
    @Autowired
    ThirdFeign thirdFeign;

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    OrderVehicalCrosstownBiz crosstownBiz;

    public void refundDeposit(OrderMQDTO orderMQDTO){
        Map<String, Dictionary> dictionaryMap = thirdFeign.dictionaryGetAll4Map().getData();
        BigDecimal illegalReserve = new BigDecimal(dictionaryMap.get(APP_ORDER+ "_"+ DictionaryKey.ILLEGAL_RESERVE).getDetail());

        //未退还， 进行保留违章预备金 的退还
        if(RefundStatusEnum.NONE.getCode().equals(orderMQDTO.getRefundStatus())) {
            OrderVehicleCrosstown crosstown = crosstownBiz.selectOne(new OrderVehicleCrosstown(){{
                setOrderId(orderMQDTO.getId());
                setType(CrosstownTypeEnum.TOUR.getCode());
            }});
            //还车扣除款 剩余的 钱，再减去违章预备金
            BigDecimal refundAmont = crosstown.getRestDeposit().subtract(illegalReserve);
            BigDecimal originalRefundAmount = crosstown.getRestDeposit().add(crosstown.getDeductionCost()).subtract(illegalReserve);
            List<DedDetailDTO> dddList = JSONUtil.toBean(crosstown.getDedDetail(), List.class);
            String refundDesc = "退还押金："+ refundAmont.toString()+ "(已扣除 违章预备金："+ illegalReserve.toString();
            for(DedDetailDTO ddd : dddList) {
                refundDesc += ", "+ ddd.getDeductions()+ ":"+ ddd.getCost();
            }
            refundDesc += ")";
            refundTrigger(orderMQDTO, orderMQDTO.getOrderRentVehicleDetail(), illegalReserve, originalRefundAmount, refundAmont, refundDesc, RefundStatusEnum.RESIDUE_ILLEGAL.getCode());
        }
    }

    public void refundTrigger(BaseOrder baseOrder, OrderRentVehicleDetail orvd, BigDecimal residueAmount, BigDecimal originalRefundAmount, BigDecimal refundAmont, String refundDesc, Integer refundStatus) {
        //退款子流程: 订单基础，退款描述，退款金额
        baseOrderBiz.refundSubProcess(baseOrder, refundDesc, originalRefundAmount, refundAmont, RefundTypeEnum.DEPOSIT.getCode(), refundStatus);
        //设置剩余没有返还的钱
        orderRentVehicleBiz.updateSelectiveById(new OrderRentVehicleDetail(){{
            setId(orvd.getId());
            setReturnPayResidue(residueAmount);
        }});
    }
}