package com.xxfc.platform.order.entity;

import lombok.Data;

import javax.persistence.*;
import java.math.BigDecimal;

@Table(name = "order_vehicle_crosstown")
@Data
public class OrderVehicleCrosstown {
    /**
     * 主键id
     */
    @Id
    private Integer id;

    /**
     * 订单id
     */
    @Column(name = "order_id")
    private Integer orderId;

    /**
     * 订单号
     */
    @Column(name = "order_no")
    private String orderNo;


    /**
     * 公里数（公里）
     */
    private Integer mileage;

    /**
     * 公里数取证照
     */
    @Column(name = "mileage_img")
    private String mileageImg;

    /**
     * 审核状态；0-未审核；1-已审核
     */
    private Boolean status;

    /**
     * 审核时间
     */
    @Column(name = "status_time")
    private Long statusTime;

    /**
     * 审核名称
     */
    @Column(name = "status_name")
    private String statusName;

    /**
     * 审核人id
     */
    @Column(name = "status_id")
    private Integer statusId;

    /**
     * 是否删除；0-正常；1-删除
     */
    @Column(name = "is_del")
    private Boolean isDel;

    /**
     * 取证图片
     */
    private String imgs;

    /**
     * 备注
     */
    private String remak;

    /**
     * 创建时间
     */
    private Long crtTime;

    /**
     * 更新时间
     */
    private Long updTime;

    /**
     * 钥匙图片
     */
    private String vehicleKey;

    /**
     * 是否有扣除项
     */
    private Boolean deduction;
    /**
     * 扣除项明细 json
     *  deductions: 扣除项
     *  cost:费用
     *  id:编号（用于顺序）
     */
    private String dedDetail;

    /**
     *  1、交车， 2、还车
     */
    private Integer type;

    /**
     * 合计扣除费用
     */
    private BigDecimal deductionCost;

    /**
     * 剩余押金
     */
    private BigDecimal restDeposit;

    /**
     * 驾驶人Id
     */
    private String userLicenseId;

    //操作人ID
    private Integer orperaterId;
}