package com.xxfc.platform.vehicle.pojo;

import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.entity.VehiclePlatCata;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 车型
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 14:50:08
 */
@Data
@Table(name = "vehicle_model")
public class VehicleModelVo extends VehicleModel implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "总数量")
	private Integer sum;


	@ApiModelProperty(value = "可租借数量")
	private Integer leasableQuantity;


	@ApiModelProperty(value = "车辆")
	private  Vehicle vehicle;


	@Column(name = "numberName")
	@ApiModelProperty(value = "乘卧数")
	private String numberName;

	@Column(name = "brandName")
	@ApiModelProperty(value = "品牌")
	private String brandName;

	/**
	 * 官网需要显示的配置列表
	 */
	List<VehiclePlatCata> UccnCataList;

}
