package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.campsite.feign.CampsiteFeign;
import com.xxfc.platform.campsite.vo.CampsiteShopDetailVo;
import com.xxfc.platform.campsite.vo.CampsiteShopPageVo;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/28 10:05
 */
@RestController
@RequestMapping("/app/unauth/campsite")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class CampsiteUccnController {

    private final CampsiteFeign campsiteFeign;


    @ApiOperation("分页查询营地列表")
    @GetMapping("/shops")
    public ObjectRestResponse<PageDataVO<CampsiteShopPageVo>> findCampsiteShopPageByType(@RequestParam(value = "type", required = false) Integer type,
                                                                                         @RequestParam(value = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                                                         @RequestParam(value = "pageSize", required = false, defaultValue = "6") Integer pageSize) {
        return campsiteFeign.findCampsiteShopPageByType(type, pageNo, pageSize);
    }

    /**
     * @param longitude 经度
     * @param latitude  纬度
     * @return
     */
    @ApiOperation("查询营地详情")
    @GetMapping("/shop")
    public ObjectRestResponse<CampsiteShopDetailVo> findCampsiteShopDetailById(@RequestParam(value = "id") Integer id,
                                                                               @RequestParam(value = "longitude", required = false) Double longitude,
                                                                               @RequestParam(value = "latitude", required = false) Double latitude) {
        return campsiteFeign.findCampsiteShopDetailById(id, longitude, latitude);
    }
}
