package com.xxfc.platform.uccn.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/26 19:00
 */
@Data
public class SummitActivityAdminVo implements Serializable {
    private static final long serialVersionUID = 1L;


    private Integer id;


    @ApiModelProperty(value = "活动主标题")
    private String title;


    @ApiModelProperty(value = "副标题（不展示）")
    private String subtitle;


    @ApiModelProperty(value = "活动主图")
    private String banner;

    @ApiModelProperty(value = "开始时间")
    private Long startTime;


    @ApiModelProperty(value = "结束时间")
    private Long endTime;

    @ApiModelProperty(value = "报名截止时间（不展示）")
    private Long regCloseTime;


    @ApiModelProperty(value = "省编码")
    private Integer provinceCode;


    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市编码")
    private Integer cityCode;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "县/镇 编码")
    private Integer townCode;

    @ApiModelProperty(value = "县/镇")
    private String town;


    @ApiModelProperty(value = "活动场地（地址格式）")
    private String address;

    @ApiModelProperty(value = "纬度（不展示）")
    private BigDecimal latitude;


    @ApiModelProperty(value = "经度 （不展示）")
    private BigDecimal longitude;


    @ApiModelProperty(value = "总人数")
    private Integer limitNum;


    @ApiModelProperty(value = "活动图文内容")
    private String content;

    @ApiModelProperty(value = "活动开关（0关，1开）")
    private Integer isShow;


    @ApiModelProperty(value = "报名开关（0开，1关）")
    private Integer isOpenReg;

    @ApiModelProperty(value = "删除（0正常，1删除）")
    private Integer isDel;


    @ApiModelProperty(value = "0是未发布，1是已发布")
    private Integer isPublish;


    @ApiModelProperty(value = "0是普通，1是置顶（首页展示）")
    private Integer isHomePage;


    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

    @ApiModelProperty(value = "更新时间")
    private Long updTime;


    @ApiModelProperty(value = "活动对象说明（不展示）")
    private String actDesc;


    @ApiModelProperty(value = "活动类型(保留，不展示)")
    private Integer type;


    @ApiModelProperty(value = "报名人数（不展示）")
    private Integer willNum;

    @ApiModelProperty(value = "1:欣欣官网 2：滴房车官网 0：无限制")
    private Integer location;

    @ApiModelProperty(value = "排序")
    private Integer rank;
}
