package com.xxfc.platform.vehicle.feign;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.*;
import com.xxfc.platform.vehicle.pojo.CompanyDetail;
import com.xxfc.platform.vehicle.pojo.RentVehicleBookDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by ace on 2017/9/15.
 */
@FeignClient(name = "vehicle")
public interface VehicleFeign {
    @GetMapping(value = "/vehicleModel/{id}")
    public ObjectRestResponse<VehicleModel> get(@PathVariable("id") int id);

    @GetMapping(value = "/vehicleInfo/{id}")
    public ObjectRestResponse<Vehicle> get(@PathVariable("id") String id);

    @RequestMapping(value = "/vehicleInfo/findById", method = RequestMethod.GET)
    public RestResponse<Vehicle> findById(@RequestParam("id")String id);

    @RequestMapping(value = "/vehicleInfo/getByIds", method = RequestMethod.GET)
    public RestResponse< List<Vehicle>> getByIds(@RequestParam("ids") List<String> id);

    //修改评分
    @RequestMapping(value = "/vehicleModel/app/addScore", method = RequestMethod.GET)
    public RestResponse addScore(@RequestParam(value="id")Integer  id, @RequestParam(value="score")Integer  score);

    @RequestMapping(value = "/vehicleInfo/rent/book/vehicle", method = RequestMethod.POST)
    public ObjectRestResponse<VehicleBookRecord> rentApplyVehicle(@RequestBody RentVehicleBookDTO rentVehicleBookDTO);

    @RequestMapping(value ="/branchCompany/app/unauth/detail/{id}",method = RequestMethod.GET)
    public ObjectRestResponse<CompanyDetail> getCompanyDetail(@PathVariable Integer id);

    //拒绝预约
    @RequestMapping(value = "/vehicleInfo/book/4employee/reject/{bookRecordId}", method = RequestMethod.PUT)
    public RestResponse<Integer> rejectVehicleBooking(@PathVariable Long bookRecordId);

    //取消预约
    @RequestMapping(value = "/vehicleInfo/unbook/4employee/{bookRecordId}", method = RequestMethod.DELETE)
    public RestResponse<Integer> unbookVehicle(@PathVariable Long bookRecordId);

    //通过预约
    @RequestMapping(value = "/vehicleInfo/book/4employee/prove/{bookRecordId}", method = RequestMethod.PUT)
    public RestResponse<Integer> proveVehicleBooking(@PathVariable Long bookRecordId);

    //获取分公司列表
    @GetMapping("/branchCompany/all")
    public  List<BranchCompany>  companyAll(
            @RequestParam(value = "dataAll")Integer dataAll,
            @RequestParam(value = "dataCompany")String dataCompany,

            @RequestParam(value = "dataZone")String dataZone);

    @RequestMapping(value = "/user/license/one", method = RequestMethod.GET)
    public RestResponse<VehicleUserLicense> one(@RequestParam(value="id",defaultValue="0")Integer  id) throws Exception;

    @RequestMapping(value = "/user/license/company/getOne", method = RequestMethod.GET)
    public RestResponse<VehicleUserLicense> getOne(
            @RequestParam(value="id",defaultValue="0")Integer  id) throws Exception ;
}
