package com.xxfc.platform.tour.handler;


import cn.hutool.json.JSONUtil;
import com.rabbitmq.client.Channel;
import com.xxfc.platform.tour.biz.BranchCompanyBiz;
import com.xxfc.platform.tour.entity.BranchCompany;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import static com.xxfc.platform.tour.config.RabbitTourConfig.*;


@Component
@Slf4j
public class BranchCompanyMQHandler {

    @Autowired
    BranchCompanyBiz branchCompanyBiz;



    /**
     * 同步门店信息
     * @param
     */
    @RabbitListener(queues = COMPANY_UPD_QUEUE)
    public void integralHandler(Message message, @Headers Map<String, Object> headers, Channel channel) {
        log.info("同步门店信息 messageJson："+ JSONUtil.parse(message));
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String messageId = message.getMessageProperties().getMessageId();
                    String msg = new String(message.getBody(), "UTF-8");
                    BranchCompany branchCompany = JSONUtil.toBean(msg, BranchCompany.class);
                    branchCompanyBiz.addOrUpd(branchCompany);
                    executorService.shutdown();
                    Long deliveryTag = (Long) headers.get(AmqpHeaders.DELIVERY_TAG);
                    // 手动签收
                    channel.basicAck(deliveryTag, false);
                } catch (Exception e) {
                    log.info("接收到的消息失败");
                    try {
                        channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                    } catch (IOException i) {
                        log.error(e.getMessage(), i);
                    }
                    log.error(e.getMessage(), e);
                }
            }
        });
    }
}
