package com.xxfc.platform.tour.config;

import com.github.wxiaoqi.security.common.config.rabbit.BindDTO;
import com.github.wxiaoqi.security.common.config.rabbit.RabbitCommonConfig;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.*;

/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 *
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitTourConfig extends RabbitCommonConfig {



    //同步企业信息
    public static final String CORPORATION_UPD_QUEUE = "tourCorporation:upd.queue";

    //同步门店信息
    public static final String COMPANY_UPD_QUEUE = "tourCompany:upd.queue";


    static {
        myQueue = new ArrayList<BindDTO>() {{
            //企业
            add(new BindDTO(CORPORATION_UPD_QUEUE, VEHICLE_TOPIC, KEY_CORPORATION_UPD));
            //门店
            add(new BindDTO(COMPANY_UPD_QUEUE, VEHICLE_TOPIC, KEY_COMPANY_UPD));
        }};
    }
}

