package com.xxfc.platform.tour.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

/**
 * @author libin
 * @version 1.0
 * @description  旅游标签DTO
 * @data 2019/6/12 13:35
 */
@Data
public class TourTagDTO {


    /**
     * 主键id
     */
    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 图片
     */

    @ApiModelProperty(value = "图片")
    private String img;

    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    private String describe;

    /**
     * 链接
     */
    @ApiModelProperty(value = "链接")
    private String link;

    /**
     * 是否热门：0-否；1-是
     */
    @ApiModelProperty(value = "是否热门：0-否；1-是")
    private Integer isHot;

    /**
     * 成单量
     */
    @ApiModelProperty(value = "成单量")
    private Integer count;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer rank;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Long ctrTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;

    /**
     * 是否删除:0-正常；1-删除
     */
    @ApiModelProperty(value = "是否删除:0-正常；1-删除")
    private Integer isDel;

    @ApiModelProperty(value = "banner数量")
    private int bannerNums;

}
