package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.biz.AccompanyingItemBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.AccompanyingItem;
import com.xxfc.platform.vehicle.pojo.AddOrUpdateAccompanyingItem;
import com.xxfc.platform.vehicle.pojo.dto.AccompanyingItemFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.AccompanyingItemVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;
import java.util.List;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/accompanyingItem")
@IgnoreClientToken
@Slf4j
public class AccompanyingItemController extends BaseController<AccompanyingItemBiz> {


    /**
     *
     * @param id
     * @return
     * @throws Exception
     */
    @GetMapping(value ="/{id}")
    public RestResponse<AccompanyingItem> get(@PathVariable Integer id) throws Exception{
        return RestResponse.codeAndData(RestResponse.SUC_CODE,baseBiz.get(id));
    }

    @RequestMapping(value ="/all",method = RequestMethod.GET)
    public RestResponse<List<AccompanyingItem>> getAll(){
        return RestResponse.codeAndData(RestResponse.SUC_CODE,baseBiz.getAll());
    }


    @RequestMapping(value ="/page",method = RequestMethod.POST)
    public RestResponse<PageDataVO<AccompanyingItem>> getByPage(@RequestBody AccompanyingItemFindDTO accompanyingItemFindDTO){
            return RestResponse.data(baseBiz.getByPage(accompanyingItemFindDTO));
    }

    @RequestMapping(value ="",method = RequestMethod.POST)
    public RestResponse<Integer> add(@RequestBody AddOrUpdateAccompanyingItem addOrUpdateAccompanyingItem) throws Exception{
        return baseBiz.add(addOrUpdateAccompanyingItem);
    }

    @RequestMapping(value ="",method = RequestMethod.PUT)
    public RestResponse<Integer> update(@RequestBody AddOrUpdateAccompanyingItem addOrUpdateAccompanyingItem) throws Exception{
        return baseBiz.update(addOrUpdateAccompanyingItem);
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.DELETE)
    public RestResponse<Integer> del(@PathVariable Integer id) throws Exception{
        return baseBiz.del(id);
    }

    @GetMapping("/app/unauth/items")
    public RestResponse<List<AccompanyingItemVo>> listAccompanyingItemVo(){
        List<AccompanyingItemVo> accompanyingItemVos = baseBiz.listAllItem(Collections.EMPTY_LIST);
        return RestResponse.codeAndData(RestResponse.SUC_CODE,accompanyingItemVos);
    }

    @GetMapping("/app/unauth/type_items")
    public RestResponse<List<AccompanyingItemVo>> listAccompanyingItemVoByTypes(@RequestParam(value = "type",required = false) List<Integer> type){
        List<AccompanyingItemVo> accompanyingItemVos = baseBiz.listAllItem(type);
        return RestResponse.codeAndData(RestResponse.SUC_CODE,accompanyingItemVos);
    }
}
