package com.xxfc.platform.uccn.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/26 18:54
 */
@Data
public class SummitActivitySaveDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    private Integer id;

    @ApiModelProperty(value = "活动主标题")
    private String title;

    @ApiModelProperty(value = "副标题（不展示）")
    private String subtitle;


    @ApiModelProperty(value = "活动主图")
    private String banner;


    @ApiModelProperty(value = "开始时间")
    private Long startTime;


    @ApiModelProperty(value = "结束时间")
    private Long endTime;


    @ApiModelProperty(value = "报名截止时间（不展示）")
    private Long regCloseTime;


    @ApiModelProperty(value = "省编码")
    private Integer provinceCode;


    @ApiModelProperty(value = "省")
    private String province;


    @ApiModelProperty(value = "市编码")
    private Integer cityCode;


    @ApiModelProperty(value = "市")
    private String city;


    @ApiModelProperty(value = "县/镇 编码")
    private Integer townCode;


    @ApiModelProperty(value = "县/镇")
    private String town;


    @ApiModelProperty(value = "活动场地（地址格式）")
    private String address;


    @ApiModelProperty(value = "纬度（不展示）")
    private BigDecimal latitude;


    @ApiModelProperty(value = "经度 （不展示）")
    private BigDecimal longitude;


    @ApiModelProperty(value = "总人数")
    private Integer limitNum;


    @ApiModelProperty(value = "活动图文内容")
    private String content;


    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;


    @ApiModelProperty(value = "活动对象说明（不展示）")
    private String actDesc;


    @ApiModelProperty(value = "活动类型(保留，不展示)")
    private Integer type;


    @ApiModelProperty(value = "1:欣欣官网 2：滴房车官网 0：无限制")
    private Integer location;


    @ApiModelProperty(value = "排序")
    private Integer rank;

    @ApiModelProperty("seo*html标签优化")
    private String alt;
}
