package com.xxfc.platform.tour.vo;


import java.math.BigDecimal;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.xxfc.platform.tour.dto.GoodBannerDTO;
import com.xxfc.platform.tour.dto.GoodTagDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 旅游商品表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
public class TourGoodDetailVo {


    private Integer id;

    //商品名
	@ApiModelProperty(value = "商品名")
    private String name;
	
	    //商品封面图
	@ApiModelProperty(value = "商品封面图")
    private String cover;
	
	//商品原价
	@ApiModelProperty(value = "商品原价")
    private BigDecimal price;
	
	//儿童价格
	@ApiModelProperty(value = "儿童价格")
    private BigDecimal childPrice;
	
	//商品浏览量
	@ApiModelProperty(value = "商品浏览量")
    private Integer viewCount;
	
	//商品销售量
	@ApiModelProperty(value = "商品销售量")
    private Integer saleCount;
	
	//商品描述
	@ApiModelProperty(value = "商品描述")
    private String describe;
	
	//商品详情(行程亮点)
	@ApiModelProperty(value = "商品详情(行程亮点)")
    private String content;
	
	//行程介绍
	@ApiModelProperty(value = "行程介绍")
    private String introduce;

	//费用说明
	@ApiModelProperty(value = "费用说明")
	private String explain;
	
	//排序
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	//状态:0-未发布;1-上架；2-下架
	@ApiModelProperty(value = "状态:0-未发布;1-上架；2-下架")
    private Integer status;

	//天数
	@ApiModelProperty(value = "天数")
	private Integer number;
	
	//创建时间
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	//更新时间
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;

	//是否省外；0-省内；1-省外
	@ApiModelProperty(value = "是否省外；0-省内；1-省外")
	private Integer isOutside;
	
	//是否推荐:0-未推荐；1-已推荐
	@ApiModelProperty(value = "是否推荐:0-未推荐；1-已推荐")
    private Integer recommend;
	
	//是否会员价:0-否；1-是
	@ApiModelProperty(value = "是否会员价:0-否；1-是")
    private Integer isMember;
	
	//库存
	@ApiModelProperty(value = "库存")
    private Integer stock;
	
	//单位
	@ApiModelProperty(value = "单位")
    private String unit;

	//等级价格
	@ApiModelProperty(value = "等级价格")
	private List<TourMemberVo>   memberVo;

	//出发时间
	@ApiModelProperty(value = "出发时间")
	private List<TourDepartTimeVo> tourDepartTimeVo;

	//出发地点
	@ApiModelProperty(value = "出发地点")
	private List<TourDepartVo> tourDepartVo;

	//商品轮播
	@ApiModelProperty(value = "商品轮播")
	List<GoodBannerDTO> bannerDTOS;

	//目的地
	@ApiModelProperty(value = "目的地")
	private String destination;

	//商品标签
	@ApiModelProperty(value = "商品标签")
	List<GoodTagDTO> tagDTOS;

   private String posterBackground;

	@ApiModelProperty("seo*html标签优化")
	private String alt;

}
