package com.github.wxiaoqi.security.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReferralCodeUtil {
	//验证码长度
	private static final int LEN = 6;
	//验证码字符初始列表
	private static final char STUFFS[] = {
			'E','5','F','C','D','G','3','H',
			'Q','A','4','B','1','N','P','I',
			'J','2','R','S','T','U','V','6',
			'7','M','W','X','8','K','L','Y'};
	
	private static final int PERMUTATION;
	private static final int MAX_COMBINATION;

	private static char[] _stuffs = STUFFS;
	
	static {
		PERMUTATION = permutation(LEN);
		MAX_COMBINATION = combination(_stuffs.length, LEN);
	}

//	public static void resetStuffs() {
//		int length = STUFFS.length;
//		char[] stuffs = new char[length];
//		for (int i = 0; i < length; ++i) {
//			stuffs[i] = STUFFS[i];
//		}
//		Random random = new Random();
//		for (int i = 0; i < length; i++) {
//			int p = random.nextInt(length);
//			char tmp = stuffs[i];
//			stuffs[i] = stuffs[p];
//			stuffs[p] = tmp;
//		}
//		_stuffs = stuffs;
//	}
	
	private static int combination(int n,int m) {
		int com = 1;
		for(int i = n - m + 1; i <= n ; ++i) {
			com *= i;
		}
		for(int i = 2; i <= m ; ++i ) {
			com /= i;
		}
		return com;
	}
	
	private static int permutation(int n) {
		int per = 1;
		for(int i = 2; i <= n ; ++i) {
			per *= i;
		}
		return per;
	}
	
	public static int decode(String code) {
		if(code.length() != LEN) {
			throw new RuntimeException("invalid code");
		}
		char[] chars = new char[LEN];
		for(int i = 0; i < LEN;++i) {
			chars[i] = code.charAt(i);
		}
		int com = combination(chars);
		int per = permutation(chars);
		return com * PERMUTATION + per;
	}
	
	public static String encode(int val) {
		int com = val / PERMUTATION;
		if(com >= MAX_COMBINATION) {
			throw new RuntimeException("id can't be greater than 652458239");
		}
		int per = val % PERMUTATION;
		char[] chars = combination(com);
		chars = permutation(chars,per);
		return new String(chars);
	}
	
	private static char[] combination(int com){
		char[] chars = new char[LEN];
		int start = 0;
		int index = 0;
		while (index < LEN) {
			for(int s = start; s < _stuffs.length; ++s ) {
				int c = combination(_stuffs.length - s - 1, LEN - index - 1);
				if(com >= c) {
					com -= c;
					continue;
				}
				chars[index++] = _stuffs[s];
				start = s + 1;
				break;
			}
		}
		return chars;
	}
	
	private static char[] sort(char[] src) {
		char[] sort = new char[src.length];
		int index = 0;
		for(int i = 0; i < _stuffs.length; ++i) {
			if(find(src, _stuffs[i]) != -1) {
				sort[index++] = _stuffs[i];
			}
		}
		return sort;
	}
	
	private static int combination(char[] chars) {
		int[] offset = new int[LEN];
		char[] sort = sort(chars);
		for(int i = 0; i < sort.length;++i) {
			offset[i] = find(_stuffs, sort[i]);
			if(offset[i] == -1) {
				throw new RuntimeException("invalid code");
			}
		}
		int com = 0;
		for(int i = 0;i < offset.length;++i) {
			if(i == 0) {
				if(offset[0] == 0) {
					continue;
				}
				for(int n = 0; n < offset[0];++n) {
					com += combination(_stuffs.length -  n - 1, LEN - 1);
				}
				continue;
			}
			
			if(offset[i] - offset[i - 1] <= 1) {
				continue;
			}
			
			for(int n = offset[i-1] + 1; n < offset[i];++n) {
				com += combination(_stuffs.length -  n - 1, LEN - i - 1);
			}
		}
		
		return com;
	}
	
	private static char[] permutation(char[] chars,int per){
		char[] tmpchars = new char[chars.length];
		System.arraycopy(chars, 0, tmpchars, 0, chars.length);
		int[] offset = new int[chars.length];
		int step = chars.length;
		for(int i = chars.length -1;i >= 0;--i) {
			offset[i] = per % step;
			per /= step;
			step --;
		}
		
		for(int i = 0; i < chars.length;++i) {
			if(offset[i] == 0)
				continue;
			char tmp = tmpchars[i];
			tmpchars[i] = tmpchars[i - offset[i]];
			tmpchars[i - offset[i]] = tmp;
		}
		
		return tmpchars;
	}
	
	private static int find(char[] chars,char ch) {
		for(int i = 0;i < chars.length;++i) {
			if(chars[i] == ch) {
				return i;
			}
		}
		return -1;
	}
	
	private static int permutation(char[] chars){
		char[] sort = sort(chars);
		int[] offset = new int[chars.length];
		for(int i =chars.length -1;i >=0;--i ) {
			int f = find(chars, sort[i]);
			offset[i] = i - f;
			char tmp = chars[i];
			chars[i] = chars[i - offset[i]];
			chars[i - offset[i]] = tmp;
		}
		int per = 0;
		int step = 1;
		for(int i = 0; i < offset.length;++i ) {
			per = per * step + offset[i];
			step++;
		}
		return per;
	}

	public static void main(String[] args) {
//		try {
//			List<String> lists = new ArrayList<>();
//			Set<String> sets = new HashSet<>();
//			File file = new File("./log2.txt");
//			BufferedOutputStream buff = new BufferedOutputStream(new FileOutputStream(file));
//			resetStuffs();
//			for (int i = 1; i< 10000000; ++i) {
//				String code = encode(i);
//				int nid = decode(code);
//				if (i != nid) {
//					break;
//				}
//				String str = i + "->" + code + "->" + nid + "\n";
//				buff.write(str.getBytes());
//
//				lists.add(code);
//				sets.add(code);
//			}
//			String result = "lists.size=" + lists.size() + ", sets.size=" + sets.size() + "\n";
//			buff.write(result.getBytes());
//			buff.flush();
//			buff.close();
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
		Map<String, Integer> map = new HashMap<String, Integer>();
		for (int i = 0; i < 10000; i++) {
			String key = encode(i);
			System.out.println(key);
			if(null == map.get(key)) {
				map.put(key, 1);
			}else {
				System.out.println("重复"+ key+ ":"+ i);
				map.put(key, map.get(key) + 1);
			}
		}

		int flag = 0;
		Set<Map.Entry<String, Integer>> list = map.entrySet();
		for(Map.Entry<String, Integer> e : list) {
			if(e.getValue() > 1) {
				flag++;
				System.out.println(e.getKey()+ ":"+ e.getValue());
			}
		}
		System.out.println("flag : "+ flag);
	}
}