package com.xxfc.platform.vehicle.rest.admin;

import cn.hutool.core.io.IoUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.biz.BranchCompanyVehicleCountBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.pojo.BranchCompanyVehicleCountVo;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyVehicleCountDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

@Controller
@RequestMapping(value = "/bg-vehicle/count")
public class BranchCompanyVehicleCountController extends BaseController<BranchCompanyVehicleCountBiz> {

	@Autowired
	private HttpServletResponse response;


	@GetMapping(value = "/getAll")
	@ResponseBody
	public ObjectRestResponse getAll(BranchCompanyVehicleCountDTO branchCompanyVehicleCountDTO) {
		return baseBiz.getAllCountInfo(branchCompanyVehicleCountDTO);
	}
	@GetMapping("/app/unauth/export")
	public void exportVehicleInfo(BranchCompanyVehicleCountDTO branchCompanyVehicleCountDTO) throws Exception {
		PageDataVO<BranchCompanyVehicleCountVo> pageDataVO = baseBiz.getAllCountInfo(branchCompanyVehicleCountDTO).getData();
		if (pageDataVO != null && pageDataVO.getData() != null) {
			ExcelWriter writer = ExcelUtil.getWriter(true);
			writer.addHeaderAlias("companyId", "公司ID");
			writer.addHeaderAlias("companyName", "公司名");
			writer.addHeaderAlias("countYear", "年");
			writer.addHeaderAlias("countMonth", "月");
			writer.addHeaderAlias("countWeek", "周");
			writer.addHeaderAlias("weekStartDate", "开始日期");
			writer.addHeaderAlias("weekEndDate", "结束日期");
			writer.addHeaderAlias("countDate", "日期");
			writer.addHeaderAlias("vehicleNum", "数量");
			writer.setColumnWidth(7, 17);
			writer.setColumnWidth(5, 17);
			writer.setColumnWidth(6, 17);
			writer.setColumnWidth(1, 17);
			// 一次性写出内容，使用默认样式，强制输出标题
			writer.write(pageDataVO.getData(), true);
			//response为HttpServletResponse对象
			response.setContentType("application/vnd.ms-excel;charset=utf-8");
			//test.xls是弹出下载对话框的文件名，不能为中文，中文请自行编码
			response.setHeader("Content-Disposition", "attachment;filename=vehicleInfo.xlsx");
			//out为OutputStream，需要写出到的目标流
			ServletOutputStream out = response.getOutputStream();
			writer.flush(out, true);
			// 关闭writer，释放内存
			writer.close();
			//此处记得关闭输出Servlet流
			IoUtil.close(out);
		}

	}
}
