package com.xxfc.platform.im.entity;

import lombok.Data;

import javax.persistence.*;

@Table(name = "im_comment")
@Data
public class ImComment {
    @Id
    private Long id;

    /**
     * 问题Id
     */
    @Column(name = "question_id")
    private Long questionId;

    /**
     * 评论类容
     */
    private String content;

    private Long time;

    /**
     * 用户id
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 是否显示
     */
    private Integer visible = 1;

    /**
     * 是否只有自己可见(评论审核时仅自己可见)
     */
    @Column(name = "visible_own")
    private Integer visibleOwn = 1;

    /**
     * 状态
     */
    private Integer state = 0;

    /**
     * 是否删除
     */
    @Column(name = "is_del")
    private Boolean isDel = false;

    private String nickname;

    private String picUrl;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Long crtTime;
    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Long updTime;



}