package com.xxfc.platform.activity;

import com.ace.cache.EnableAceCache;
import com.github.wxiaoqi.security.api.vo.config.HeaderConfig;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import com.github.wxiaoqi.security.common.annotation.AddBasicConfiguration;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import tk.mybatis.spring.annotation.MapperScan;

/**
 * @author libin
 * @version 1.0
 * @description 活动
 * @data 2019/6/14 11:19
 */
@SpringBootApplication(scanBasePackages = {
        "com.xxfc.platform",
        "com.github.wxiaoqi.security.common.handler",
        "com.github.wxiaoqi.security.common.log",
        "com.github.wxiaoqi.security.admin.support.aop",
        "com.github.wxiaoqi.security.common.support"
})
@EnableAspectJAutoProxy(exposeProxy = true)
@EnableAsync
@EnableDiscoveryClient
@EnableScheduling
@EnableAceAuthClient
@EnableFeignClients(value = {"com.github.wxiaoqi.security.auth.client.feign", "com.github.wxiaoqi.security.admin.feign","com.xxfc.platform"},defaultConfiguration = HeaderConfig.class)
@EnableAceCache
@EnableCaching
@MapperScan(basePackages = "com.xxfc.platform.activity.mapper")
@AddBasicConfiguration
public class ActivityApplication {

    public static void main(String[] args) {
        SpringApplication.run(ActivityApplication.class, args);
    }
}
