package com.xxfc.platform.activity.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description 中奖记录
 * @data 2019/12/3 16:14
 */
@Data
@Table(name = "activity_winning_record")
public class ActivityWinningRecord implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator = "JDBC")
    private Long id;
    @Column(name = "user_id")
    private Integer userId;
    @Column(name = "activity_id")
    private Integer activityId;
    @ApiModelProperty("1:线上 2：现场")
    @Column(name = "prize_type")
    private Integer prizeType;
    @Column(name = "prize_name")
    private String prizeName;
    @Column(name = "icon_path")
    private String iconPath;
    @ApiModelProperty("是否中奖 1：是 0:否")
    @Column(name = "has_winning")
    private Integer hasWinning;
    @ApiModelProperty("兑奖码")
    @Column(name = "expiry_date_code")
    private String expiryDateCode;
    @Column(name = "crt_time")
    private Date crtTime;
    @Column(name = "lottery_time")
    private Date lotteryTime;
    @Column(name = "goods_id")
    private Integer goodsId;
}
