package com.xxfc.platform.order.jobhandler;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.xxfc.platform.order.biz.StaffStatisticsBiz;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description 员工业绩统计job
 * @data 2019/11/26 10:12
 */
@Component
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@Slf4j
public class SaffStatisticsJobHandler extends IJobHandler {
    private final StaffStatisticsBiz staffStatisticsBiz;
    private final VehicleFeign vehicleFeign;
    @Override
    public ReturnT<String> execute(String arg) throws Exception {
        //1.查询公司
        Map<Integer, String> companyMap = vehicleFeign.findCompanyMap();
        Date date= null;
         if (StringUtils.hasText(arg)){
             date = DateUtil.parse(arg,"yyyy-MM-dd");
         }else {
             date = DateUtil.yesterday().toJdkDate();
         }
        Date startDate = DateUtil.beginOfDay(date).toJdkDate();
        Date endDate = DateUtil.endOfDay(date).toJdkDate();
        staffStatisticsBiz.staffStatisticsJob(startDate,endDate,companyMap);
        return ReturnT.SUCCESS;
    }
}
