package com.xxfc.platform.order.entity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/25 12:19
 */
@Table(name = "staff_statistics")
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
@Api("员工业绩统计")
public class StaffStatistics implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator = "JDBC")
    private Long id;

    @Column(name = "year")
    @ApiModelProperty(value = "年份")
    protected String year;

    @Column(name = "month")
    @ApiModelProperty(value = "月份----->201908")
    protected String month;

    @Column(name = "date")
    @ApiModelProperty(value = "年月日")
    protected Date date;

    @Column(name = "week_of_year")
    @ApiModelProperty(value = "1周年的第几周--->201922")
    protected String weekOfYear;

    @ApiModelProperty("员工所属公司id")
    @Column(name = "compnay_id")
    private Integer companyId;

    @ApiModelProperty("公司名称")
    @Column(name = "company_name")
    private String companyName;

    @ApiModelProperty("员工id")
    @Column(name = "user_id")
    private Integer userId;

    @ApiModelProperty("员工身份id")
    @Column(name = "user_postion_id")
    private Integer userPostionId;

    @ApiModelProperty("员工身份")
    @Column(name = "postion_name")
    private String postionName;

    @ApiModelProperty("租车订单量")
    @Column(name = "rent_vehicle_order_num")
    private Integer rentVehicleOrderNum;

    @ApiModelProperty("租车订单总额(不包含押金，不计免赔金额)")
    @Column(name = "rent_vehicle_amount")
    private BigDecimal rentVehicleAmount;

    @ApiModelProperty("会员订单量")
    @Column(name = "member_order_num")
    private Integer memberOrderNum;

    @ApiModelProperty("会员订单总额")
    @Column(name = "member_amount")
    private BigDecimal memberAmount;

    @ApiModelProperty("旅游订单量")
    @Column(name = "travel_order_num")
    private Integer travelOrderNum;

    @ApiModelProperty("旅游订单总额")
    @Column(name = "travel_amount")
    private BigDecimal travelAmount;

    @ApiModelProperty("销售总额")
    @Column(name = "sell_amount")
    private BigDecimal sellAmount;

    @ApiModelProperty("提成")
    @Column(name = "royalty_amount")
    private BigDecimal royaltyAmount;

    @ApiModelProperty("创建时间")
    @Column(name = "crt_time")
    private Date crtTime;
}
