package com.xxfc.platform.activity.biz;

import cn.hutool.core.collection.CollectionUtil;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xxfc.platform.activity.constant.CouponUsed;
import com.xxfc.platform.activity.dto.CouponDTO;
import com.xxfc.platform.activity.dto.CouponFindDTO;
import com.xxfc.platform.activity.entity.Coupon;
import com.xxfc.platform.activity.entity.UserCoupon;
import com.xxfc.platform.activity.vo.CouponPagVo;
import com.xxfc.platform.activity.vo.CouponTitleVo;
import com.xxfc.platform.activity.vo.CouponVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.xxfc.platform.activity.mapper.CouponMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.*;

/**
 * 优惠券表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-21 14:34:49
 */
@Service
public class CouponBiz extends BaseBiz<CouponMapper, Coupon> {
    @Autowired
    private UserCouponBiz userCouponBiz;

    //获取优惠卷
    public  Coupon getCouponByUsed(Integer used){
        Example example=new Example(Coupon.class);
        example.createCriteria().andEqualTo("used",used )
                .andEqualTo("status",1).andEqualTo("isDel",0);
         List<Coupon> list=selectByExample(example);
         if (list.size()>0){
            return list.get(0);
         }
        return null;
    }

    public PageDataVO<CouponPagVo> listCouponWithPage(CouponFindDTO couponFindDTO) {
        PageDataVO<CouponPagVo> couponPagVo = new PageDataVO<>();
        Example example = new Example(Coupon.class);
        Example.Criteria criteria = example.createCriteria();
        if (!StringUtils.isEmpty(couponFindDTO.getTitle())){
            criteria.andLike("title",String.format("%%%s%%",couponFindDTO.getTitle()));
        }
        if (Objects.nonNull(couponFindDTO.getChannel())){
            criteria.andEqualTo("channel",couponFindDTO.getChannel());
        }
        if (Objects.nonNull(couponFindDTO.getType())){
           criteria.andEqualTo("type",couponFindDTO.getType());
        }
        if (Objects.nonNull(couponFindDTO.getStatus())){
            criteria.andEqualTo("status",couponFindDTO.getStatus());
        }
        criteria.andEqualTo("isDel",0);
        example.setOrderByClause("crt_time DESC");

        PageDataVO<Coupon> couponPage = PageDataVO.pageInfo(couponFindDTO.getPage(), couponFindDTO.getLimit(), () -> mapper.selectByExample(example));
        List<Coupon> data = couponPage.getData();
       if (CollectionUtils.isEmpty(data)){
           return couponPagVo;
       }

        List<CouponPagVo> couponPagVos = new ArrayList<>();
        CouponPagVo coupon ;
        for (Coupon coup : data) {
            coupon = new CouponPagVo();
            BeanUtils.copyProperties(coup,coupon);
            couponPagVos.add(coupon);
        }
        couponPagVo.setPageNum(couponPage.getPageNum());
        couponPagVo.setPageSize(couponPage.getTotalPage());
        couponPagVo.setTotalPage(couponPage.getTotalPage());
        couponPagVo.setTotalCount(couponPage.getTotalCount());
        couponPagVo.setData(couponPagVos);
        return couponPagVo;

    }
    public CouponVo findCouponById(Integer id) {
        CouponVo couponVo= new CouponVo();
        Coupon coupon = mapper.selectByPrimaryKey(id);
        BeanUtils.copyProperties(coupon,couponVo);
        return couponVo;
    }

    public int addCoupon(CouponDTO couponDTO, UserDTO userDTO) {
        Coupon coupon = new Coupon();
        BeanUtils.copyProperties(couponDTO,coupon);
        if (Objects.nonNull(couponDTO.getId())){
            coupon.setUpdTime(Instant.now().toEpochMilli());
            coupon.setUpdUser(userDTO.getId());
            coupon.setUpdName(userDTO.getUsername());
            return mapper.updateByPrimaryKeySelective(coupon);
        }else {
            coupon.setCrtTime(Instant.now().toEpochMilli());
            coupon.setCrtUser(userDTO.getId());
            coupon.setCrtName(userDTO.getUsername());
            return mapper.insertSelective(coupon);
        }
    }

    public int updateCouponDelStateById(Integer id,UserDTO userDTO) {
        Coupon coupon = new Coupon();
        coupon.setId(id);
        coupon.setUpdName(userDTO.getUsername());
        coupon.setUpdUser(userDTO.getId());
        coupon.setUpdTime(Instant.now().toEpochMilli());
        coupon.setIsDel(1);
        return mapper.updateByPrimaryKeySelective(coupon);
    }


    public List<CouponTitleVo> getCouponTitleList() {
        return  mapper.selectTitles();
    }

    public Map<String, Coupon> getCoupons() {
        HashMap<String, Coupon> map = Maps.newHashMap();
        List<Coupon> coupons = mapper.getCoupons();
        if (CollectionUtil.isNotEmpty(coupons)) {
            for (Coupon coupon : coupons) {
                map.put(coupon.getId().toString(),coupon);
            }
        }
        return map;
    }

    public List<Coupon> couponsByTickerNoList(List<String> tickerNoList) {

       return mapper.couponsByTickerNoList(tickerNoList);
    }
}