package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppUserSellingWaterBiz;
import com.github.wxiaoqi.security.admin.bo.UserStaffBo;
import com.github.wxiaoqi.security.admin.dto.OrderWaterDTO;
import com.github.wxiaoqi.security.admin.vo.SellingWalletPagVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 11:35
 */
@RestController
@RequestMapping("/sellingwater")
public class UserSellingWaterController {

    @Autowired
    private AppUserSellingWaterBiz appUserSellingWaterBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @Autowired
    private AppUserSellingWaterBiz waterBiz;

    @GetMapping("/page")
    public ObjectRestResponse<SellingWalletPagVo> findSellingWaterPage(@RequestParam(required = false,value = "type") Integer wating,
                                                                       @RequestParam("pageNo") Integer pageNo,
                                                                       @RequestParam("pageSize") Integer pageSize,
                                                                       HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            SellingWalletPagVo sellingWalletPagVo = appUserSellingWaterBiz.findSellingWaterPageByWaiting(wating, Integer.valueOf(infoFromToken.getId()), pageNo, pageSize);
            return ObjectRestResponse.succ(sellingWalletPagVo);
        } catch (Exception e) {
            throw new BaseException(e);
        }
    }

    @GetMapping("/pagea")
    public ObjectRestResponse<SellingWalletPagVo> findSellingWaterPagea(@RequestParam(required = false,value = "type") Integer wating,
                                                                       @RequestParam("pageNo") Integer pageNo,
                                                                       @RequestParam("pageSize") Integer pageSize,
                                                                       HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            SellingWalletPagVo sellingWalletPagVo = appUserSellingWaterBiz.findSellingWaterPageForAppByWaiting(wating, Integer.valueOf(infoFromToken.getId()), pageNo, pageSize);
            return ObjectRestResponse.succ(sellingWalletPagVo);
        } catch (Exception e) {
            throw new BaseException(e);
        }
    }

    @PostMapping("app/unauth/order")
    public ObjectRestResponse order(@RequestBody OrderWaterDTO orderWaterDTO) {
        try {
            waterBiz.orderWater(orderWaterDTO);
            return ObjectRestResponse.succ();
        } catch (Exception e) {
            throw new BaseException(e);
        }
    }

    @ApiOperation("员工佣金")
    @GetMapping("/list_staff_sellerwater")
   public List<UserStaffBo> findStaffSellerWater(@RequestParam(value = "userIds",required = false) List<Integer> userIds,
                                                 @RequestParam(value = "startDate") Date startDate,
                                                 @RequestParam(value = "endDate") Date endDate){
       return appUserSellingWaterBiz.findStatffSellerWaterByUserIdsAndTime(userIds,startDate,endDate);
    }

}
