package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.vehicle.biz.VehicleCommonPriceInfoBiz;
import com.xxfc.platform.vehicle.entity.VehicleCommonPriceInfo;
import com.xxfc.platform.vehicle.pojo.dto.VehicleCommonPriceDto;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("vehicleCommonPriceInfo")
public class VehicleCommonPriceInfoController extends BaseController<VehicleCommonPriceInfoBiz,VehicleCommonPriceInfo>{

	@PostMapping(value = "/admin/addOrUpdate")
	public ObjectRestResponse saveOrUpdate(@RequestBody VehicleCommonPriceInfo vehicleCommonPriceInfo) {
		return baseBiz.addOrUpdate(vehicleCommonPriceInfo);
	}

	@GetMapping(value = "getOneByVehicleId")
	public  ObjectRestResponse getOneByVehicleId(String vehicleId) {
		return ObjectRestResponse.succ(baseBiz.getByVehicleId(vehicleId));
	}

	@GetMapping(value = "getAllByVehicleIds")
	public ObjectRestResponse getAllByVehicleIds(String vehicleIds) {
		return baseBiz.getAllByVehicleIds(vehicleIds);
	}

	@GetMapping(value = "getAll")
	public ObjectRestResponse selectList(VehicleCommonPriceDto dto) {
		return baseBiz.selectList(dto);
	}

	@GetMapping(value = "getOne")
	public ObjectRestResponse getOne(Integer id) {
		return ObjectRestResponse.succ(baseBiz.selectById(id));
	}
}